IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RespondentDisplayedVariables]') AND TYPE in (N'U'))
BEGIN
    CREATE TABLE [RespondentDisplayedVariables](
        [ResRespondent] [int] NOT NULL,
		[VariableName] nvarchar(255) NOT NULL,
		[Matrix] [int] NOT NULL,
		CONSTRAINT PK_RespondentDisplayedVariables PRIMARY KEY CLUSTERED (ResRespondent, VariableName, Matrix),
		CONSTRAINT FK_RespondentDisplayedVariables_Respondent FOREIGN KEY (ResRespondent) 
		REFERENCES [Respondent](ResRespondent)
		ON DELETE CASCADE
	)
END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VSE_sp_UpdateRespondentDisplayedVariables]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
	DROP PROCEDURE [VSE_sp_UpdateRespondentDisplayedVariables]
GO
CREATE PROCEDURE [VSE_sp_UpdateRespondentDisplayedVariables]
	@ResRespondent INT,
	@VariableNames NVARCHAR(MAX),
    @Matrix INT
AS
    DECLARE @stmt nvarchar(MAX) = '
        INSERT INTO [RespondentDisplayedVariables] 
        SELECT
            @ResRespondent,
            ids,
            @Matrix
        FROM 
        (
            values ' + @VariableNames + '
        ) as t(ids) 
        WHERE 
            ids NOT IN (
                SELECT 
                    VariableName 
                FROM 
                    RespondentDisplayedVariables 
                WHERE 
                    ResRespondent = @ResRespondent
                AND
                    Matrix = @Matrix
            )
    '

    EXEC sp_executesql @stmt, N'@ResRespondent INT, @Matrix INT', @ResRespondent, @Matrix
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VSE_sp_GetRespondentDisplayedVariables]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
	DROP PROCEDURE [VSE_sp_GetRespondentDisplayedVariables]
GO
CREATE PROCEDURE [VSE_sp_GetRespondentDisplayedVariables]
	@ResRespondent INT
AS
    SELECT
        VariableName,
        Matrix
    FROM
        [RespondentDisplayedVariables]
    WHERE
        ResRespondent = @ResRespondent
GO
